﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace TwoCamWPF.Helpers
{
       [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
    public struct MEMORYSTATUS
    {
        /// <summary>
        /// Size of the MEMORYSTATUS data structure, in bytes. You do not need to set this member before calling the GlobalMemoryStatus function; the function sets it. 
        /// </summary>
        public uint dwLength;

        /// <summary>
        /// Number between 0 and 100 that specifies the approximate percentage of physical memory that is in use (0 indicates no memory use and 100 indicates full memory use). 
        /// Windows NT:  Percentage of approximately the last 1000 pages of physical memory that is in use.
        /// </summary>
        public uint dwMemoryLoad;

        /// <summary>
        /// Total size of physical memory, in bytes. 
        /// </summary>
        public uint dwTotalPhys;

        /// <summary>
        /// Size of physical memory available, in bytes
        /// </summary>
        public uint dwAvailPhys;

        /// <summary>
        /// Size of the committed memory limit, in bytes. 
        /// </summary>
        public uint dwTotalPageFile;

        /// <summary>
        /// Size of available memory to commit, in bytes. 
        /// </summary>
        public uint dwAvailPageFile;

        /// <summary>
        /// Total size of the user mode portion of the virtual address space of the calling process, in bytes. 
        /// </summary>
        public uint dwTotalVirtual;

        /// <summary>
        /// Size of unreserved and uncommitted memory in the user mode portion of the virtual address space of the calling process, in bytes. 
        /// </summary>
        public uint dwAvailVirtual;

    } // class MEMORYSTATUS


    static class MemoryHelper
    {

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool GlobalMemoryStatus(ref MEMORYSTATUS lpBuffer);

        public static uint GetPhysicalMemorySize()
        {
            MEMORYSTATUS ms = new MEMORYSTATUS();
            ms.dwLength = 32;
            if (!GlobalMemoryStatus(ref ms)) return 0;
            return ms.dwTotalPhys;
        }

        
    }
}
